/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerEffect;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolHarvestContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.utils.TooltipKey;

public class ImpregnableModifier
extends Modifier
implements ProjectileLaunchModifierHook,
ConditionalStatModifierHook {
    private static final Component UNBREAKING = TConstruct.makeTranslation((String)"modifier", (String)"impregnable.unbreaking");

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT, TinkerHooks.PROJECTILE_LAUNCH);
    }

    private static float getBonus(LivingEntity living, RegistryObject<? extends TinkerEffect> effect, int level, float scale) {
        int effectLevel = ((TinkerEffect)effect.get()).getLevel(living) + 1;
        return (float)(level * effectLevel) / scale;
    }

    public void afterBlockBreak(IToolStackView tool, int level, ToolHarvestContext context) {
        if (context.canHarvest() && context.isEffective() && !context.isAOE()) {
            LivingEntity living = context.getLiving();
            int effectLevel = Math.min(31, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(living) + 1);
            ((TinkerEffect)Utils.impregnableEffect.get()).apply(living, 160, effectLevel, true);
        }
    }

    public int onDamageTool(IToolStackView tool, int level, int amount, @Nullable LivingEntity holder) {
        float bonus = ImpregnableModifier.getBonus(holder, Utils.impregnableEffect, level, 6.0f);
        int off = 0;
        for (int i = 0; i < amount; ++i) {
            if (!(RANDOM.nextFloat() >= 1.0f / bonus)) continue;
            ++off;
        }
        return amount - off;
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity shooter, Projectile projectile, @Nullable AbstractArrow arrow, NamespacedNBT persistentData, boolean primary) {
        if (primary && (arrow == null || arrow.m_36792_())) {
            int effectLevel = Math.min(15, ((TinkerEffect)Utils.impregnableEffect.get()).getLevel(shooter) + 1);
            ((TinkerEffect)Utils.impregnableEffect.get()).apply(shooter, 100, effectLevel, true);
        }
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        return baseValue;
    }

    public void addInformation(IToolStackView tool, int level, @Nullable Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        float bonus;
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && key == TooltipKey.SHIFT && (bonus = ImpregnableModifier.getBonus((LivingEntity)player, Utils.impregnableEffect, level, 6.0f)) > 0.0f) {
            this.addPercentTooltip(UNBREAKING, 1.0f / bonus, tooltip);
        }
    }
}

